/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import satisfyu.candlelight.client.gui.NotePaperGui;
import satisfyu.candlelight.util.CandlelightIdentifier;

public abstract class NoteGui
extends Screen {
    public static final ResourceLocation NOTE_TEXTURE = new CandlelightIdentifier("textures/gui/note_paper_gui.png");
    private static final Component EDIT_TITLE_TEXT = Component.m_237113_((String)"Enter Note Title");
    private static final Component FINALIZE_WARNING_TEXT = Component.m_237115_((String)"book.finalizeWarning");
    private static final FormattedCharSequence BLACK_CURSOR_TEXT = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.BLACK));
    private static final FormattedCharSequence GRAY_CURSOR_TEXT = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY));
    protected final Player player;
    protected final ItemStack itemStack;
    protected boolean dirty;
    private boolean signing;
    private int tickCounter;
    private final List<String> text = Lists.newArrayList();
    private String title = "";
    private final TextFieldHelper currentPageSelectionManager = new TextFieldHelper(this::getCurrentPageContent, this::setPageContent, this::getClipboard, this::setClipboard, string -> string.length() < 1024 && this.f_96547_.m_92920_(string, 114) <= 128);
    private final TextFieldHelper noteTitleSelectionManager = new TextFieldHelper(() -> this.title, title -> {
        this.title = title;
    }, this::getClipboard, this::setClipboard, string -> string.length() < 16);
    private long lastClickTime;
    private int lastClickIndex = -1;
    private Button doneButton;
    private Button signButton;
    private Button finalizeButton;
    private Button cancelButton;
    @Nullable
    private PageContent pageContent = PageContent.EMPTY;
    private final Component signedByText;

    public NoteGui(Player player, ItemStack itemStack) {
        super(GameNarrator.f_93310_);
        this.player = player;
        this.itemStack = itemStack;
        CompoundTag nbtCompound = itemStack.m_41783_();
        if (nbtCompound != null) {
            List<String> string2 = this.text;
            Objects.requireNonNull(string2);
            this.loadPages(nbtCompound, string2::add);
        }
        if (this.text.isEmpty()) {
            this.text.add("");
        }
        this.signedByText = Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.DARK_GRAY);
    }

    protected void m_7856_() {
        this.invalidatePageContent();
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(true);
        }
        this.signButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, 196, 98, 20, (Component)Component.m_237115_((String)"book.signButton"), button -> {
            this.signing = true;
            this.updateButtons();
        }));
        this.doneButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 2, 196, 98, 20, CommonComponents.f_130655_, button -> {
            this.f_96541_.m_91152_(null);
            this.finalizeNote(false);
        }));
        this.finalizeButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, 196, 98, 20, (Component)Component.m_237115_((String)"book.finalizeButton"), button -> {
            if (this.signing) {
                this.finalizeNote(true);
                this.f_96541_.m_91152_(null);
            }
        }));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 2, 196, 98, 20, CommonComponents.f_130656_, button -> {
            if (this.signing) {
                this.signing = false;
            }
            this.updateButtons();
        }));
        this.updateButtons();
    }

    public void loadPages(CompoundTag compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        ListTag listTag = compoundTag.m_128437_("text", 8).m_6426_();
        if (Minecraft.m_91087_().m_167974_() && compoundTag.m_128425_("filtered_pages", 10)) {
            CompoundTag compoundTag2 = compoundTag.m_128469_("filtered_pages");
            intFunction = i -> {
                String string = String.valueOf(i);
                return compoundTag2.m_128441_(string) ? compoundTag2.m_128461_(string) : listTag.m_128778_(i);
            };
        } else {
            intFunction = arg_0 -> ((ListTag)listTag).m_128778_(arg_0);
        }
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            consumer.accept(intFunction.apply(i2));
        }
    }

    protected void removeEmptyPages() {
        ListIterator<String> listIterator = this.text.listIterator(this.text.size());
        while (listIterator.hasPrevious() && listIterator.previous().isEmpty()) {
            listIterator.remove();
        }
    }

    protected abstract void finalizeNote(boolean var1);

    protected void writeNbtData(boolean signNote) {
        ListTag nbtList = new ListTag();
        Stream<StringTag> nbts = this.text.stream().map(StringTag::m_129297_);
        Objects.requireNonNull(nbtList);
        nbts.forEach(arg_0 -> nbtList.add(arg_0));
        if (!this.text.isEmpty()) {
            this.itemStack.m_41700_("text", (Tag)nbtList);
        }
        if (signNote) {
            this.itemStack.m_41700_("author", (Tag)StringTag.m_129297_((String)this.player.m_36316_().getName()));
            this.itemStack.m_41700_("title", (Tag)StringTag.m_129297_((String)this.title.trim()));
        }
    }

    private void setClipboard(String clipboard) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)clipboard);
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.tickCounter;
    }

    public void m_7861_() {
        if (this.f_96541_ != null) {
            this.f_96541_.f_91068_.m_90926_(false);
        }
    }

    private void updateButtons() {
        this.doneButton.f_93624_ = !this.signing;
        this.signButton.f_93624_ = !this.signing;
        this.cancelButton.f_93624_ = this.signing;
        this.finalizeButton.f_93624_ = this.signing;
        this.finalizeButton.f_93623_ = !this.title.trim().isEmpty();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.signing) {
            return this.keyPressedSignMode(keyCode);
        }
        boolean bl = this.keyPressedEditMode(keyCode);
        if (bl) {
            this.invalidatePageContent();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (super.m_5534_(chr, modifiers)) {
            return true;
        }
        if (this.signing) {
            boolean bl = this.noteTitleSelectionManager.m_95143_(chr);
            if (bl) {
                this.updateButtons();
                this.dirty = true;
                return true;
            }
            return false;
        }
        if (SharedConstants.m_136188_((char)chr)) {
            this.currentPageSelectionManager.m_95158_(Character.toString(chr));
            this.invalidatePageContent();
            return true;
        }
        return false;
    }

    private boolean keyPressedEditMode(int keyCode) {
        if (Screen.m_96634_((int)keyCode)) {
            this.currentPageSelectionManager.m_95188_();
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            this.currentPageSelectionManager.m_95178_();
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            this.currentPageSelectionManager.m_95165_();
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            this.currentPageSelectionManager.m_95142_();
            return true;
        }
        TextFieldHelper.CursorStep selectionType = Screen.m_96637_() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        switch (keyCode) {
            case 257: 
            case 335: {
                this.currentPageSelectionManager.m_95158_("\n");
                return true;
            }
            case 259: {
                this.currentPageSelectionManager.m_232572_(-1, selectionType);
                return true;
            }
            case 261: {
                this.currentPageSelectionManager.m_232572_(1, selectionType);
                return true;
            }
            case 262: {
                this.currentPageSelectionManager.m_232575_(1, Screen.m_96638_(), selectionType);
                return true;
            }
            case 263: {
                this.currentPageSelectionManager.m_232575_(-1, Screen.m_96638_(), selectionType);
                return true;
            }
            case 264: {
                this.moveDownLine();
                return true;
            }
            case 265: {
                this.moveUpLine();
                return true;
            }
            case 268: {
                this.moveToLineStart();
                return true;
            }
            case 269: {
                this.moveToLineEnd();
                return true;
            }
        }
        return false;
    }

    private void moveUpLine() {
        this.moveVertically(-1);
    }

    private void moveDownLine() {
        this.moveVertically(1);
    }

    private void moveVertically(int lines) {
        int i = this.currentPageSelectionManager.m_95194_();
        int j = this.getPageContent().getVerticalOffset(i, lines);
        this.currentPageSelectionManager.m_95179_(j, Screen.m_96638_());
    }

    private void moveToLineStart() {
        if (Screen.m_96637_()) {
            this.currentPageSelectionManager.m_95176_(Screen.m_96638_());
        } else {
            int i = this.currentPageSelectionManager.m_95194_();
            int j = this.getPageContent().getLineStart(i);
            this.currentPageSelectionManager.m_95179_(j, Screen.m_96638_());
        }
    }

    private void moveToLineEnd() {
        if (Screen.m_96637_()) {
            this.currentPageSelectionManager.m_95186_(Screen.m_96638_());
        } else {
            PageContent pageContent = this.getPageContent();
            int i = this.currentPageSelectionManager.m_95194_();
            int j = pageContent.getLineEnd(i);
            this.currentPageSelectionManager.m_95179_(j, Screen.m_96638_());
        }
    }

    private boolean keyPressedSignMode(int keyCode) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.finalizeNote(true);
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91152_(null);
                    }
                }
                return true;
            }
            case 259: {
                this.noteTitleSelectionManager.m_95189_(-1);
                this.updateButtons();
                this.dirty = true;
                return true;
            }
        }
        return false;
    }

    private String getCurrentPageContent() {
        return 0 < this.text.size() ? this.text.get(0) : "";
    }

    private void setPageContent(String newContent) {
        if (0 < this.text.size()) {
            this.text.set(0, newContent);
            this.dirty = true;
            this.invalidatePageContent();
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        this.m_7522_(null);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)NOTE_TEXTURE);
        int x = (this.f_96543_ - 192) / 2;
        this.m_93228_(matrices, x, 2, 0, 0, 192, 192);
        if (this.signing) {
            boolean bl = this.tickCounter / 6 % 2 == 0;
            FormattedCharSequence orderedText = FormattedCharSequence.m_13696_((FormattedCharSequence)FormattedCharSequence.m_13714_((String)this.title, (Style)Style.f_131099_), (FormattedCharSequence)(bl ? BLACK_CURSOR_TEXT : GRAY_CURSOR_TEXT));
            int k = this.f_96547_.m_92852_((FormattedText)EDIT_TITLE_TEXT);
            this.f_96547_.m_92889_(matrices, EDIT_TITLE_TEXT, (float)(x + 36 + (114 - k) / 2), 34.0f, 0);
            int l = this.f_96547_.m_92724_(orderedText);
            this.f_96547_.m_92877_(matrices, orderedText, (float)(x + 36 + (114 - l) / 2), 50.0f, 0);
            int m = this.f_96547_.m_92852_((FormattedText)this.signedByText);
            this.f_96547_.m_92889_(matrices, this.signedByText, (float)(x + 36 + (114 - m) / 2), 60.0f, 0);
            this.f_96547_.m_92857_((FormattedText)FINALIZE_WARNING_TEXT, x + 36, 82, 114, 0);
        } else {
            PageContent pageContent = this.getPageContent();
            for (Line line : pageContent.lines) {
                this.f_96547_.m_92889_(matrices, line.text, (float)line.x, (float)line.y, -16777216);
            }
            this.drawSelection(pageContent.selectionRectangles);
            this.drawCursor(matrices, pageContent.position, pageContent.atEnd);
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private void drawCursor(PoseStack matrices, Position position, boolean atEnd) {
        if (this.tickCounter / 6 % 2 == 0) {
            position = this.absolutePositionToScreenPosition(position);
            if (!atEnd) {
                int var10001 = position.x;
                int var10002 = position.y - 1;
                int var10003 = position.x + 1;
                int var10004 = position.y;
                Objects.requireNonNull(this.f_96547_);
                GuiComponent.m_93172_((PoseStack)matrices, (int)var10001, (int)var10002, (int)var10003, (int)(var10004 + 9), (int)-16777216);
            } else {
                this.f_96547_.m_92883_(matrices, "_", (float)position.x, (float)position.y, 0);
            }
        }
    }

    private void drawSelection(Rect2i[] selectionRectangles) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Rect2i rect2i : selectionRectangles) {
            int i = rect2i.m_110085_();
            int j = rect2i.m_110086_();
            int k = i + rect2i.m_110090_();
            int l = j + rect2i.m_110091_();
            bufferBuilder.m_5483_((double)i, (double)l, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)k, (double)l, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)k, (double)j, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)i, (double)j, 0.0).m_5752_();
        }
        tessellator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    private Position screenPositionToAbsolutePosition(Position position) {
        return new Position(position.x - (this.f_96543_ - 192) / 2 - 36, position.y - 32);
    }

    private Position absolutePositionToScreenPosition(Position position) {
        return new Position(position.x + (this.f_96543_ - 192) / 2 + 36, position.y + 32);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!super.m_6375_(mouseX, mouseY, button) && button == 0) {
            long l = Util.m_137550_();
            PageContent pageContent = this.getPageContent();
            int i = pageContent.getCursorPosition(this.f_96547_, this.screenPositionToAbsolutePosition(new Position((int)mouseX, (int)mouseY)));
            if (i >= 0) {
                if (i == this.lastClickIndex && l - this.lastClickTime < 250L) {
                    if (!this.currentPageSelectionManager.m_95198_()) {
                        this.selectCurrentWord(i);
                    } else {
                        this.currentPageSelectionManager.m_95188_();
                    }
                } else {
                    this.currentPageSelectionManager.m_95179_(i, Screen.m_96638_());
                }
                this.invalidatePageContent();
            }
            this.lastClickIndex = i;
            this.lastClickTime = l;
        }
        return true;
    }

    private void selectCurrentWord(int cursor) {
        String string = this.getCurrentPageContent();
        this.currentPageSelectionManager.m_95147_(StringSplitter.m_92355_((String)string, (int)-1, (int)cursor, (boolean)false), StringSplitter.m_92355_((String)string, (int)1, (int)cursor, (boolean)false));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!super.m_7979_(mouseX, mouseY, button, deltaX, deltaY) && button == 0) {
            PageContent pageContent = this.getPageContent();
            int i = pageContent.getCursorPosition(this.f_96547_, this.screenPositionToAbsolutePosition(new Position((int)mouseX, (int)mouseY)));
            this.currentPageSelectionManager.m_95179_(i, true);
            this.invalidatePageContent();
        }
        return true;
    }

    private PageContent getPageContent() {
        if (this.pageContent == null) {
            this.pageContent = this.createPageContent();
        }
        return this.pageContent;
    }

    private void invalidatePageContent() {
        this.pageContent = null;
    }

    private PageContent createPageContent() {
        int l;
        Position position;
        boolean bl;
        String string = this.getCurrentPageContent();
        if (string.isEmpty()) {
            return PageContent.EMPTY;
        }
        int i = this.currentPageSelectionManager.m_95194_();
        int j = this.currentPageSelectionManager.m_95197_();
        ArrayList intList = new ArrayList();
        ArrayList list = new ArrayList();
        MutableInt mutableInt = new MutableInt();
        MutableBoolean mutableBoolean = new MutableBoolean();
        StringSplitter textHandler = this.f_96547_.m_92865_();
        textHandler.m_92364_(string, 114, Style.f_131099_, true, (style, start, end) -> {
            int h = mutableInt.getAndIncrement();
            String substring = string.substring(start, end);
            mutableBoolean.setValue(substring.endsWith("\n"));
            String string2 = StringUtils.stripEnd((String)substring, (String)" \n");
            Objects.requireNonNull(this.f_96547_);
            int b = h * 9;
            Position position = this.absolutePositionToScreenPosition(new Position(0, b));
            intList.add(start);
            list.add(new Line(style, string2, position.x, position.y));
        });
        int[] is = intList.stream().mapToInt(Integer::intValue).toArray();
        boolean bl2 = bl = i == string.length();
        if (bl && mutableBoolean.isTrue()) {
            int var10003 = list.size();
            Objects.requireNonNull(this.f_96547_);
            position = new Position(0, var10003 * 9);
        } else {
            int k = NoteGui.getLineFromOffset(is, i);
            l = this.f_96547_.m_92895_(string.substring(is[k], i));
            Objects.requireNonNull(this.f_96547_);
            position = new Position(l, k * 9);
        }
        ArrayList<Rect2i> list2 = new ArrayList<Rect2i>();
        if (i != j) {
            int o;
            l = Math.min(i, j);
            int m = Math.max(i, j);
            int n = NoteGui.getLineFromOffset(is, l);
            if (n == (o = NoteGui.getLineFromOffset(is, m))) {
                Objects.requireNonNull(this.f_96547_);
                int p = n * 9;
                int q = is[n];
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, m, p, q));
            } else {
                int p = n + 1 > is.length ? string.length() : is[n + 1];
                Objects.requireNonNull(this.f_96547_);
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, p, n * 9, is[n]));
                for (int q = n + 1; q < o; ++q) {
                    Objects.requireNonNull(this.f_96547_);
                    int r = q * 9;
                    String string2 = string.substring(is[q], is[q + 1]);
                    int s = (int)textHandler.m_92353_(string2);
                    Position var10002 = new Position(0, r);
                    Objects.requireNonNull(this.f_96547_);
                    list2.add(this.getRectFromCorners(var10002, new Position(s, r + 9)));
                }
                int var10004 = is[o];
                Objects.requireNonNull(this.f_96547_);
                list2.add(this.getLineSelectionRectangle(string, textHandler, var10004, m, o * 9, is[o]));
            }
        }
        return new PageContent(string, position, bl, is, list.toArray(new Line[0]), list2.toArray(new Rect2i[0]));
    }

    static int getLineFromOffset(int[] lineStarts, int position) {
        int i = Arrays.binarySearch(lineStarts, position);
        return i < 0 ? -(i + 2) : i;
    }

    private Rect2i getLineSelectionRectangle(String string, StringSplitter handler, int selectionStart, int selectionEnd, int lineY, int lineStart) {
        String string2 = string.substring(lineStart, selectionStart);
        String string3 = string.substring(lineStart, selectionEnd);
        Position position = new Position((int)handler.m_92353_(string2), lineY);
        int var10002 = (int)handler.m_92353_(string3);
        Objects.requireNonNull(this.f_96547_);
        Position position2 = new Position(var10002, lineY + 9);
        return this.getRectFromCorners(position, position2);
    }

    private Rect2i getRectFromCorners(Position start, Position end) {
        Position position = this.absolutePositionToScreenPosition(start);
        Position position2 = this.absolutePositionToScreenPosition(end);
        int i = Math.min(position.x, position2.x);
        int j = Math.max(position.x, position2.x);
        int k = Math.min(position.y, position2.y);
        int l = Math.max(position.y, position2.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PageContent {
        static final PageContent EMPTY = new PageContent("", new Position(0, 0), true, new int[]{0}, new Line[]{new Line(Style.f_131099_, "", 0, 0)}, new Rect2i[0]);
        private final String pageContent;
        final Position position;
        final boolean atEnd;
        private final int[] lineStarts;
        final Line[] lines;
        final Rect2i[] selectionRectangles;

        public PageContent(String pageContent, Position position, boolean atEnd, int[] lineStarts, Line[] lines, Rect2i[] selectionRectangles) {
            this.pageContent = pageContent;
            this.position = position;
            this.atEnd = atEnd;
            this.lineStarts = lineStarts;
            this.lines = lines;
            this.selectionRectangles = selectionRectangles;
        }

        public int getCursorPosition(Font renderer, Position position) {
            int var10000 = position.y;
            Objects.requireNonNull(renderer);
            int i = var10000 / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.pageContent.length();
            }
            Line line = this.lines[i];
            return this.lineStarts[i] + renderer.m_92865_().m_92360_(line.content, position.x, line.style);
        }

        public int getVerticalOffset(int position, int lines) {
            int m;
            int i = NotePaperGui.getLineFromOffset(this.lineStarts, position);
            int j = i + lines;
            if (0 <= j && j < this.lineStarts.length) {
                int k = position - this.lineStarts[i];
                int l = this.lines[j].content.length();
                m = this.lineStarts[j] + Math.min(k, l);
            } else {
                m = position;
            }
            return m;
        }

        public int getLineStart(int position) {
            int i = NotePaperGui.getLineFromOffset(this.lineStarts, position);
            return this.lineStarts[i];
        }

        public int getLineEnd(int position) {
            int i = NotePaperGui.getLineFromOffset(this.lineStarts, position);
            return this.lineStarts[i] + this.lines[i].content.length();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Line {
        final Style style;
        final String content;
        final Component text;
        final int x;
        final int y;

        public Line(Style style, String content, int x, int y) {
            this.style = style;
            this.content = content;
            this.x = x;
            this.y = y;
            this.text = Component.m_237113_((String)content).m_6270_(style);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private record Position(int x, int y) {
    }
}

